;==================================================

;mouse via keyboard

;==================================================

;mouse via keyboard by jeeswg
;[first released: 2023-05-03]
;[updated: N/A]

;for AHK v2
;can be used with AHK V1.1.35+ if use JEEAhk1FC.ahk

;contains hotkeys for:
;left/right click via keyboard
;two-stage (startpoint/endpoint) drag via keyboard
;continuously move mouse up/down/left/right via keyboard
;move cursor to the middle of one of 9 regions via keyboard

;note: '+^#!' correspond to Shift/Ctrl/Win/Alt respectively

;note: the comment character ';', can be used to comment out hotkey labels

;==================================================

;settings:
vIsV1 := (InStr(A_AhkVersion, "1.") == 1)
SetDefaultMouseSpeed(0) ;to make Win+Arrow hotkeys smooth
SetBatchLines := 0 ;for AHK v2, so it doesn't complain
if vIsV1
	SetBatchLines -1
return

;==================================================

^#Right:: ;anywhere - mouse via keyboard - left-click/right-click
{
	SendInput("{Click right}")
	return ;for AHK v1
}

^#Left:: ;anywhere - mouse via keyboard - left-click/right-click
{
	SendInput("{Blind}{Ctrl up}{Win up}{Left up}")
	SendInput("{LButton down}")
	return ;for AHK v1
}

^#Left up:: ;anywhere - mouse via keyboard - left-click/right-click
{
	SendInput("{Blind}{Ctrl up}{Win up}{Left up}")
	SendInput("{LButton up}")
	return ;for AHK v1
}

;==================================================

;additional hotkeys within code:
;Ctrl & Win & Left ;click
;Ctrl & AppsKey & Left ;click
;Ctrl & Win & Right ;right-click
;Ctrl & AppsKey & Right ;right-click

#Up:: ;anywhere - mouse via keyboard - up/down/left/right
#Down:: ;anywhere - mouse via keyboard - up/down/left/right
#Left:: ;anywhere - mouse via keyboard - up/down/left/right
#Right:: ;anywhere - mouse via keyboard - up/down/left/right
AppsKey & Up:: ;anywhere - mouse via keyboard - up/down/left/right
AppsKey & Down:: ;anywhere - mouse via keyboard - up/down/left/right
AppsKey & Left:: ;anywhere - mouse via keyboard - up/down/left/right
AppsKey & Right:: ;anywhere - mouse via keyboard - up/down/left/right
#!Up:: ;anywhere - mouse via keyboard - up/down/left/right (small jump)
#!Down:: ;anywhere - mouse via keyboard - up/down/left/right (small jump)
#!Left:: ;anywhere - mouse via keyboard - up/down/left/right (small jump)
#!Right:: ;anywhere - mouse via keyboard - up/down/left/righ (small jump)
{
	global vGblMouseMoveInProgress
	if IsSet(vGblMouseMoveInProgress)
	&& vGblMouseMoveInProgress
		return

	;send click:
	;Ctrl & Win/AppsKey & Left/Right (3-key hotkey):
	if (InStr(A_ThisHotkey, "Left") || InStr(A_ThisHotkey, "Right"))
	&& GetKeyState("Ctrl", "P")
	{
		if InStr(A_ThisHotkey, "Left")
			SendInput("{Click}")
		if InStr(A_ThisHotkey, "Right")
			SendInput("{Click right}")
		return
	}

	vGblMouseMoveInProgress := True

	vDist := 7
	if InStr(A_ThisHotkey, "!") ;small jump
		vDist := 1

	if InStr(A_ThisHotkey, "#")
		vKey := "LWin"
	if InStr(A_ThisHotkey, "AppsKey")
		vKey := "AppsKey"

	while GetKeyState(vKey, "P")
	{
		vCurX := vCurY := 0
		if (vDrnU := GetKeyState("Up", "P"))
			vCurY -= vDist
		if (vDrnD := GetKeyState("Down", "P"))
			vCurY += vDist
		if (vDrnL := GetKeyState("Left", "P"))
			vCurX -= vDist
		if (vDrnR := GetKeyState("Right", "P"))
			vCurX += vDist

		;send click:
		;Ctrl & Win/AppsKey & Left/Right (3-key hotkey):
		if GetKeyState("Ctrl", "P")
		{
			if vDrnL
				SendInput("{Click}")
			if vDrnR
				SendInput("{Click right}")
			break
		}

		if (vDrnU+vDrnD+vDrnL+vDrnR == 0)
			break

		MouseMove(vCurX, vCurY,, "R")
	}

	vGblMouseMoveInProgress := False
	return ;for AHK v1
}

;==================================================

;note: NumpadHome and Numpad7 are the same key:
;i.e. NumpadHome when NumLock is off
;i.e. Numpad7 when NumLock is on

;divide screen into 9 regions ('rule of thirds' grid):
#NumpadEnd:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadDown:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadPgDn:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadLeft:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadClear:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadRight:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadHome:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadUp:: ;anywhere - mouse via keyboard - jump to region of screen
#NumpadPgUp:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad1:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad2:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad3:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad4:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad5:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad6:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad7:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad8:: ;anywhere - mouse via keyboard - jump to region of screen
#Numpad9:: ;anywhere - mouse via keyboard - jump to region of screen
{
	vKey := StrReplace(A_ThisHotkey, "#Numpad")
	;AHK v2: static oMapNumpad := Map(StrSplit("End,1,Down,2,PgDn,3,Left,4,Clear,5,Right,6,Home,7,Up,8,PgUp,9", ",")*)
	if !IsSet(oMapNumpad)
		oMapNumpad := Map(StrSplit("End,1,Down,2,PgDn,3,Left,4,Clear,5,Right,6,Home,7,Up,8,PgUp,9", ",")*)
	if (StrLen(vKey) > 1)
		vKey := oMapNumpad[vKey]

	;e.g. middle of top-left ninth of screen is 1/6 along, 1/6 down
	;e.g. middle of middle ninth of screen is 3/6 along, 3/6 down
	;e.g. middle of bottom-right ninth of screen is 5/6 along, 5/6 down
	vNumX := SubStr("123123123", vKey, 1)
	vNumY := SubStr("333222111", vKey, 1)
	vCurX := Round((vNumX*2-1)/6*A_ScreenWidth)
	vCurY := Round((vNumY*2-1)/6*A_ScreenHeight)

	vCMM := A_CoordModeMouse
	vDMS := A_DefaultMouseSpeed
	CoordMode("Mouse", "Screen")
	SetDefaultMouseSpeed(0)
	MouseMove(vCurX, vCurY)
	CoordMode("Mouse", vCMM)
	SetDefaultMouseSpeed(vDMS)
	return ;for AHK v1
}

;==================================================

^F6:: ;anywhere - mouse via keyboard - drag (stage 1)
^#F6:: ;anywhere - mouse via keyboard - drag (stage 1)
{
	global vGblCurX1, vGblCurY1
	CoordMode("Mouse", "Screen")
	MouseGetPos(vIsV1?vGblCurX1:&vGblCurX1, vIsV1?vGblCurY1:&vGblCurY1)
	return ;for AHK v1
}

^F7:: ;anywhere - mouse via keyboard - drag (stage 2)
^#F7:: ;anywhere - mouse via keyboard - drag (stage 2)
{
	global vGblCurX1, vGblCurY1
	if !IsSet(vGblCurX1) || !IsSet(vGblCurY1)
	|| (vGblCurX1 = "") || (vGblCurY1 = "")
		return

	CoordMode("Mouse", "Screen")
	MouseGetPos(vIsV1?vCurX2:&vCurX2, vIsV1?vCurY2:&vCurY2)
	vDistX := vGblCurX1 - vCurX2
	vDistY := vGblCurY1 - vCurY2
	MouseClickDrag("Left", vGblCurX1, vGblCurY1, vCurX2, vCurY2, 0) ;works
	vGblCurX1 := vGblCurY1 := ""
	return ;for AHK v1
}

;==================================================
